#include <bits/stdc++.h>

int xa[200001], ya[200001];

struct PairHash 
{
    template <class T1, class T2>
    std::size_t operator () (const std::pair<T1, T2>& p) const 
    {
        auto h1 = std::hash<T1>{}(p.first);
        auto h2 = std::hash<T2>{}(p.second);

        return h1 ^ (h2 << 1); 
    }
};

int main()
{
    int n, r = 0;
    std::unordered_set<std::pair<int, int>, PairHash> map;
    std::cin >> n;

    for(int i = 0; i < n; i++)
    {
        std::cin >> xa[i] >> ya[i];
    }

    for(int i = 0; i < n - 1; i++)
    {
        int x0 = xa[i], y0 = ya[i];

        for(int j = i + 1; j < n; j++)
        {
            int x = xa[j], y = ya[j];

            auto p1 = std::make_pair(x, y0), p2 = std::make_pair(x0, y);

            if(abs(x - x0) == abs(y - y0) && (
                (
                    map.find(p1) == map.end() &&
                    map.find(p2) == map.end()
                )
            ))
            {
                map.insert(p1);
                map.insert(p2);
                r += 2;
            }

            if((x == x0 && abs(x - x0) % 2 == 0) || (y == y0 && abs(y - y0) % 2 == 0))
                r++;
        }
    }

    std::cout << r;

    return 0;
}